# HQAI CyberLab

**Program:** Master of Science in Cybersecurity  
**Institution:** American Public University System (APUS)  
**Course:** ISSC698 – Cybersecurity Studies: Capstone Practical  
**Student:** Daniel N'kombo  

**Student Project:**  
**Design of Hybrid Quantum–Neural AI Systems for Predictive Cyber Threat Detection and Adversarial Resistance**

---

## Overview
HQAI CyberLab is an executable hybrid quantum–classical cybersecurity simulation environment.
It demonstrates predictive cyber threat detection, adversarial robustness testing,
and executive-level cybersecurity decision metrics.

The system integrates variational quantum circuits, classical neural networks,
and adversarial machine learning techniques to reflect realistic enterprise SOC conditions.

---

## License

© 2025 Daniel N'kombo. All rights reserved.

This software is provided **strictly for academic and educational purposes**.

Permission is granted to faculty, academic reviewers, and students of the
**American Public University System (APUS)** to view, execute, and evaluate
this project solely for instructional, grading, and assessment activities
associated with the **ISSC698 Capstone course**.

### Restrictions
- Commercial use is prohibited.
- Redistribution outside an academic context is not permitted without written authorization.
- Modifications are allowed for instructional review, demonstration, or grading purposes,
  provided proper attribution is maintained.

This license preserves the intellectual property rights of the student
while enabling transparent academic evaluation.

---

## Academic Disclaimer
This project represents a student capstone submission and does not constitute
official research, commercial software, or endorsement by American Public University System.

---


## Quick Start (Fix for `ModuleNotFoundError: No module named 'hqai'`)

This project uses a `src/` layout. To make imports work reliably, install it in editable mode:

```bash
python -m venv hqai-env
# Windows:
hqai-env\Scripts\activate
# macOS/Linux:
source hqai-env/bin/activate

python -m pip install --upgrade pip
pip install -r requirements.txt

# Install the package so `hqai` is importable
pip install -e .
```

Run the end-to-end pipeline:

```bash
hqai-end-to-end --epochs 5 --attack pgd
# or
python scripts/run_end_to_end.py --epochs 5 --attack pgd
```

Outputs are saved to `./outputs/` (metrics.json and plots).

---

## Executive Dashboard (No Backend)

This repo includes an **HTML5 “Resilience Command Center”** dashboard that simulates mock real-time telemetry for:
- SOC (alerts, TTD/TTR, incident feed)
- MLOps (drift, confidence, FP trend, adversarial robustness)
- QuantumOps (queue depth, circuit fidelity, sampler latency, hybrid latency split)
- CloudOps (service health, p95 latency, error rate, cost spikes, pipeline lag)
- Governance (control coverage, open risks, evidence, audit events)

### How to run
1. Open this file in your browser (double-click is fine):
   - `hqai_cyberlab/docs/dashboard/index.html`
2. Use the **Scenario** buttons (Normal Ops / Adversarial Campaign / Degraded Quantum Fidelity).
3. Try the **Automation & Mitigations** controls — each action writes to the incident timeline and adjusts the metrics.

> Tip: If your browser blocks local file scripts, use a simple static server:

```bash
python -m http.server 8000
# then open http://localhost:8000/hqai_cyberlab/docs/dashboard/
```
