from dataclasses import dataclass

@dataclass
class TrainConfig:
    seed: int = 7
    n_features: int = 6
    n_qubits: int = 3
    n_layers: int = 2
    hidden_dim: int = 32
    lr: float = 1e-3
    batch_size: int = 64
    epochs: int = 10
    device: str = "cpu"

    # Robustness
    attack: str = "none"   # none|fgsm|pgd
    eps: float = 0.15
    pgd_alpha: float = 0.02
    pgd_steps: int = 10

    # Quantum-aware perturbations
    angle_sigma: float = 0.03      # parameter-shift / angle noise
    output_sigma: float = 0.01     # decoherence-style output noise

    # Qiskit noise sim (optional)
    use_qiskit_noise: bool = False
    depolarizing_p: float = 0.01
