from __future__ import annotations

# Wrapper script for convenience when running without installation.
# If you installed the package (recommended): `pip install -e .`
# you can run: `hqai-end-to-end --epochs 5 --attack pgd`

import sys
from pathlib import Path

try:
    from hqai.cli import main
except ModuleNotFoundError:
    # Add ./src to PYTHONPATH for src/ layout
    repo_root = Path(__file__).resolve().parents[1]
    src_path = repo_root / "src"
    sys.path.insert(0, str(src_path))
    from hqai.cli import main  # type: ignore

if __name__ == "__main__":
    main()
